import json
import argparse

def change_order(file_path, order_type):

    with open(file_path, 'r') as f:
        data = json.load(f)

    for item in data:
        if order_type not in item:
            print(f"Warning: {order_type} not found in item {item.get('id', 'unknown')}. Skipping.")
            continue

        order = item[order_type]
        
        if order == '1 > 2':
            item['chosen'] = item['synthesized_response_1']
            # print(item['chosen'])
            item['rejected'] = item['synthesized_response_2']
        elif order == '2 > 1':
            item['chosen'] = item['synthesized_response_2']
            item['rejected'] = item['synthesized_response_1']
        else:
            print(f"Warning: Invalid {order_type} '{order}' in item {item.get('id', 'unknown')}. Skipping.")

    # Rewrite the data to the file
    with open(file_path, 'w') as f:
        json.dump(data, f, indent=2)

def main():
    parser = argparse.ArgumentParser(description="Change order based on specified rank order")
    parser.add_argument("--file_path", type=str,default="your file", help="Path to the JSON file")
    parser.add_argument("--order_type", type=str, choices=['rank_order', '70_rank_order', 'rm_order'], default="rank_order",
                        help="Type of rank order to use")

    args = parser.parse_args()
    change_order(args.file_path, args.order_type)
    print(f"File {args.file_path} has been updated based on {args.order_type}.")

if __name__ == "__main__":
    main()